#ifndef __IPresetHandler__
#define __IPresetHandler__

#include <IO/CPresetIO.hpp>
using Exponent::IO::CPresetIO;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @deprecated Soon to be removed, remains for historical reasons
			 * @interface IPresetHandler IPresetHandler.hpp
			 * @brief Allows for responding to preset handling requests
			 *
			 * @date 11/09/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IPresetHandler.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IPresetHandler
			{
			
//	===========================================================================
			
			public:
				
//	===========================================================================
				
				/**
				 * Construction
				 */
				IPresetHandler() { }
				
				/**
				 * Destruction
				 */
				virtual ~IPresetHandler() { }

//	===========================================================================

				/**
				 * Save a preset
				 * @param presetPath The path to save to
				 * @retval bool True if you saved the preset properly, false otherwise
				 */
				virtual bool savePreset(const CSystemString &presetPath) = 0;

				/**
				 * Load a preset
				 * @param presetPath
				 * @retval bool True if you loaded the preset properly, false otherwise
				 */
				virtual bool loadPreset(const CSystemString &presetPath) = 0;

				/**
				 * Validate a preset -> Confirm that it meets the specifications YOU require
				 * @param path The path to the file to validate
				 * @param presetIO The presetIO to use to interogate the file
				 * @retval bool True if it meets the specifications YOU require, false otherwise
				 */
				virtual bool validatePreset(const CSystemString &path, CPresetIO &presetIO) = 0;

				/**
				 * Validate a preset -> Confirum that it meets you specifications
				 * @param filename The name of the file to validate
				 * @retval bool True if it meets your specifications, false otherwise
				 */
				virtual bool validatePreset(const CSystemString &filename) = 0;

				/**
				 * Get the preset extension
				 * @param theExtensionFilter Should be filled on return with the extension (eg - '*.txt')
				 * @param theExtensionDescription Should be filled on return with a description of the file (eg - 'Text documents')
				 */
				virtual void getPresetExtensionFilter(CString &theExtensionFilter, CString &theExtensionDescription) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IPresetHandler.hpp